#include <cmath>
#include <algorithm>
#include <random>

#include <iostream>

#include <exception>
#include <stdexcept>

#include <array>
#include <utility>
#include <vector>

#include <bitset>

using namespace std;

typedef long long ll;
typedef unsigned long long ull;
typedef long double ld;

// modified from a template by wleung_bvg
// https://github.com/wesley-a-leung/Problem-Setting-Resources

namespace Reader {
  enum error_type {INTERNAL_RANGE, EXTERNAL_RANGE, INVALID_ARGUMENT, WRONG_WHITESPACE};

  typedef void __attribute__((noreturn)) (*error_handler)(enum error_type e);

  void __attribute__((noreturn)) default_handler(error_type e) {
    throw runtime_error(to_string(e));
  }

  static error_handler handler = default_handler;

  void set_error_handler(error_handler f) {
    handler = f;
  }

  class FileReader {

  private:
    FILE* stream;

    bool hasLast;
    char lastChar;

  public:
    FileReader(FILE* f) : stream(f), hasLast(false), lastChar(0) {}

    char peekChar() {
      if(!hasLast) {
        lastChar = getc(stream);
        hasLast = true;
      }
      return lastChar;
    }

    char getChar() {
      char ret = peekChar();
      hasLast = false;
      return ret;
    }

    ll readInt(ll minValid, ll maxValid) {
      string token = "";
      while (isdigit(peekChar()) || peekChar() == '-') token.push_back(getChar());
      try {
        ll ret = stoll(token);

        if(minValid > ret || maxValid < ret) handler(INTERNAL_RANGE);

        return ret;
      }
      catch(const out_of_range& e) {
        handler(EXTERNAL_RANGE);
      }
      catch(const invalid_argument& e) {
        handler(INVALID_ARGUMENT);
      }
    }

    ld readFloat(ld minValid, ld maxValid) {
      string token = "";
      while (isdigit(peekChar()) || peekChar() == '-' || peekChar() == '.') token.push_back(getChar());

      try {
        ld ret = stold(token);

        if(minValid > ret || maxValid < ret) handler(INTERNAL_RANGE);

        return ret;
      }
      catch(const out_of_range& e) {
        handler(EXTERNAL_RANGE);
      }
      catch(const invalid_argument& e) {
        handler(INVALID_ARGUMENT);
      }
    }

    string readToken() {
      string token = "";
      while(!isspace(peekChar()) && peekChar() != char_traits<char>::eof()) token.push_back(getChar());

      return token;
    }

    void stripWhiteSpace() {
      while(isspace(peekChar())) getChar();
    }

    string readLine() {
      string token = "";
      while (peekChar() != '\n' && peekChar() != char_traits<char>::eof()) token.push_back(getChar());
      getChar();

      return token;
    }

    void readSpace() {
      if(getChar() != ' ') handler(WRONG_WHITESPACE);
    }

    void readNewLine() {
      if(getChar() != '\n') handler(WRONG_WHITESPACE);
    }

    void readEOF() {
      if(getChar() != char_traits<char>::eof()) handler(WRONG_WHITESPACE);
    }

  private:
    template<typename T>
    T& _fill_arr(T& res, int N, ll lo, ll hi) {
      for(int i = 0; i < N; i++) {
        res[i] = readInt(lo, hi);

        if(i == N - 1) readNewLine();
        else readSpace();
      }

      return res;
    }

  public:
    template<int length>
    array<ll, length> readIntTuple(ll lo, ll hi) {
      array<ll, length> res;

      return _fill_arr(res, length, lo, hi);
    }

    vector<ll> readIntArray(int N, ll lo, ll hi) {
      vector<ll> res(N, 0);

      return _fill_arr(res, N, lo, hi);
    }
  };
}

using Reader::FileReader;

namespace CheckerCodes {
  int AC = 0;
  int WA = 1;
  int PE = 2;
  int IE = 3;
  int PARTIAL = 7;
}

using namespace CheckerCodes;

void __attribute__((noreturn)) checker_handler(enum Reader::error_type e) {
  switch(e) {
    case Reader::error_type::INTERNAL_RANGE:
    case Reader::error_type::EXTERNAL_RANGE:
      exit(WA);

    case Reader::error_type::INVALID_ARGUMENT:
      exit(PE);

    case Reader::error_type::WRONG_WHITESPACE:
    default:
      exit(IE);
  }
}

__attribute__((constructor))
void set_checker_handler() {
  Reader::set_error_handler(checker_handler);
}

int main(int argc, char** argv) {
    FILE* in_f = fopen(argv[1], "r");
    FILE* prog_f = fopen(argv[2], "r");
    FILE* judge_f = fopen(argv[3], "r");

    FileReader in_r(in_f), prog_r(prog_f), judge_r(judge_f);

    ll K = in_r.readInt(1, 1e12);
    in_r.readNewLine();
    in_r.readEOF();

    if(judge_r.getChar() == 'S') {
      prog_r.stripWhiteSpace();

      if(prog_r.readToken() != "Sad") return CheckerCodes::WA;

      prog_r.stripWhiteSpace();

      if(prog_r.readToken() != "Chris") return CheckerCodes::WA;

      return CheckerCodes::AC;
    }

    prog_r.stripWhiteSpace();
    int N = prog_r.readInt(1, 1e5);

    vector<int> candy;

    for(int i = 0; i < N; i++) {
      prog_r.stripWhiteSpace();
      int x = prog_r.readInt(1, 1e9);

      candy.push_back(x);
    }

    sort(candy.begin(), candy.end());

    candy.push_back(0);

    ll tot = 1;

    ll cnt = 1;
    for(int i = 1; i <= N; i++) {
      if(candy[i] != candy[i - 1]) {
        tot *= cnt + 1;

        if(tot > 1e12) tot = 0;

        cnt = 0;
      }

      cnt++;
    }

    if(tot == K + 1) {
      return CheckerCodes::AC;
    }

    return CheckerCodes::WA;
}
